<?php
/**
 * @package     nerubian
 * @version     1.0
 * @author      NanoAgency
 * @link        http://www.nanoagency.co
 * @copyright   Copyright (c) 2016 NanoAgency
 * @license     GPL v2
 */

/*  Setup Theme ===================================================================================================== */
add_action( 'after_setup_theme', 'nerubian_theme_setup' );
if ( ! function_exists( 'nerubian_theme_setup' ) ) :
    function nerubian_theme_setup() {
        load_theme_textdomain( 'nerubian', get_template_directory() . '/languages' );

        //  Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

        //  Let WordPress manage the document title.
        add_theme_support( 'title-tag' );

        //  Enable support for Post Thumbnails on posts and pages.
        add_theme_support( 'post-thumbnails' );

        //Enable support for Post Formats.
        add_theme_support( 'html5', array(
            'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
        ) );

        add_theme_support( 'post-formats', array(
            'aside', 'image', 'video', 'quote', 'link', 'gallery', 'status', 'audio', 'chat'
        ) );

        add_theme_support( 'custom-header' );

        add_theme_support( 'custom-background' );

        add_theme_support( "title-tag" );

        add_theme_support( 'woocommerce' );

        add_theme_support( 'wp-block-styles' );

        add_theme_support( 'align-wide' );

        add_theme_support( 'editor-styles' );

        add_editor_style( array( 'assets/css/editor-style.css', nerubian_font_url() ) );

        add_theme_support( 'responsive-embeds' );


        add_theme_support( 'editor-color-palette', array(
            array(
                'name' => __( 'strong magenta', 'nerubian' ),
                'slug' => 'strong-magenta',
                'color' => '#a156b4',
            ),
            array(
                'name' => __( 'light grayish magenta', 'nerubian' ),
                'slug' => 'light-grayish-magenta',
                'color' => '#d0a5db',
            ),
            array(
                'name' => __( 'very light gray', 'nerubian' ),
                'slug' => 'very-light-gray',
                'color' => '#eee',
            ),
            array(
                'name' => __( 'very dark gray', 'nerubian' ),
                'slug' => 'very-dark-gray',
                'color' => '#444',
            ),
        ) );
    }
endif;

/* Thumbnail Sizes ================================================================================================== */
set_post_thumbnail_size( 220, 150, true);

add_image_size( 'nerubian-single', 870 ,522, true);

add_image_size( 'nerubian-blog-list', 292 ,190, true);
add_image_size( 'nerubian-blog-list-large', 435 ,290, true);

add_image_size( 'nerubian-mini-list', 150 ,100, true);

add_image_size( 'nerubian-blog-tran', 510 ,290, true);

add_image_size( 'nerubian-blog-trans-vertical', 510 ,490, true);

add_image_size( 'nerubian-blog-tran-large', 895 ,420, true);

add_image_size( 'nerubian-blog-grid', 510 ,290, true);

add_image_size( 'nerubian-blog-vertical', 510 ,680, true);

add_image_size( 'nerubian-video',203,110,true);

add_image_size( 'nerubian-video-large',870,489,true);
add_image_size( 'nerubian-video-horizontal',895,503,true);

add_image_size( 'nerubian-sidebar', 124 ,100, true);

add_image_size( 'nerubian-related-image',370,247,true);

/* Setup Font ======================================================================================================= */
function nerubian_font_url() {
    $fonts_url = '';
    $roboto     = _x( 'on', 'Roboto font: on or off', 'nerubian' );
    $oswald     = _x( 'on', 'Oswald font: on or off', 'nerubian' );
    if ( 'off' !== $roboto ) {
        $font_families = array();
        if ( 'off' !== $roboto ) {
            $font_families[] = 'Roboto:300,300i,400,500,700,900';
        }
        if ( 'off' !== $oswald ) {
            $font_families[] = 'Oswald:400,500,700';
        }
        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            'subset' => urlencode( 'latin,latin-ext' ),
        );

        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }

    return esc_url_raw( $fonts_url );
}


/* Load Front-end scripts  ========================================================================================== */
add_action( 'wp_enqueue_scripts', 'nerubian_theme_scripts');
function nerubian_theme_scripts() {

    // Add  fonts, used in the main stylesheet.
    wp_enqueue_style( 'nerubian_fonts', nerubian_font_url(), array(), null );
    //style plugins
    wp_enqueue_style('bootstrap',get_template_directory_uri().'/assets/css/bootstrap.min.css', array(), '3.0.2 ');
    wp_enqueue_style('awesome-font',get_template_directory_uri().'/assets/css/font-awesome.min.css', array(), '4.6.3');
    wp_enqueue_style('jquery-ui',get_template_directory_uri().'/assets/css/jquery-ui.min.css', array(), '1.11.4');
    wp_enqueue_style('themify-icons',get_template_directory_uri().'/assets/css/themify-icons.css', array(),null);
    wp_enqueue_style('photoswipe',get_template_directory_uri().'/assets/css/photoswipe.css', array(), null);
    wp_enqueue_style('default-skin',get_template_directory_uri().'/assets/css/default-skin/default-skin.css', array(), null);
    //style MAIN THEME
    wp_enqueue_style( 'nerubian-main', get_template_directory_uri(). '/style.css', array(), null );
    //style skin
    wp_enqueue_style('nerubian-css', get_template_directory_uri().'/assets/css/style-default.min.css' );

    //register all plugins
    wp_enqueue_script( 'bootstrap', get_template_directory_uri().'/assets/js/plugins/bootstrap.min.js', array(), '2.2.0', true );
    wp_enqueue_script( 'html5', get_template_directory_uri().'/assets/js/plugins/html5.min.js', array(), '2.2.0', true );
    wp_enqueue_script( 'slicknav', get_template_directory_uri().'/assets/js/plugins/jquery.slicknav.min.js', array(), '2.2.0', true );
    wp_enqueue_script( 'skip-link-focus', get_template_directory_uri().'/assets/js/plugins/skip-link-focus-fix.min.js', array(), '2.2.0', true );
    wp_enqueue_script( 'sticky-sidebar', get_template_directory_uri().'/assets/js/jquery.sticky-sidebar.js', array(), '2.2.0', true );
    wp_enqueue_script( 'slick', get_template_directory_uri().'/assets/js/plugins/slick.min.js', array(), '2.2.0', true );

    wp_enqueue_script( 'isotope', get_template_directory_uri().'/assets/js/plugins/isotope.pkgd.min.js', array(), '2.2.0', true );
    wp_enqueue_script( 'lazy', get_template_directory_uri().'/assets/js/plugins/jquery.lazy.js', array(), '2.2.0', true );
    wp_enqueue_script( 'nanoscroller', get_template_directory_uri().'/assets/js/plugins/jquery.nanoscroller.min.js',  array( 'jquery' ),'0.8.7', true );
    wp_enqueue_script( 'photoswipe', get_template_directory_uri().'/assets/js/plugins/photoswipe.min.js', array(), null, true );
    wp_enqueue_script( 'photoswipe-ui-default', get_template_directory_uri().'/assets/js/plugins/photoswipe-ui-default.min.js', array(), null, true );
    wp_register_script('tweets-widgets', get_template_directory_uri().'/assets/js/plugins/tweets-widgets.min.js','jquery', '2.3.0', true);
    wp_enqueue_script( 'videoController', get_template_directory_uri().'/assets/js/plugins/jquery.videoController.min.js', array(), '2.2.0', true );

    wp_enqueue_script('jquery-masonry');

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }

    if ( is_singular() && wp_attachment_is_image() ) {
        wp_enqueue_script( 'nerubian-theme-keyboard-image-navigation', get_template_directory_uri() . '/assets/js/keyboard-image-navigation.min.js', array( 'jquery' ), '20141010' );
    }

    //jquery MAIN THEME
    wp_enqueue_script('nerubian-init', get_template_directory_uri() . '/assets/js/dev/nerubian-init.js', array('jquery'),null, true);
    wp_enqueue_script('nerubian-slick', get_template_directory_uri() . '/assets/js/dev/slick-init.js', array('jquery'),null, true);
    wp_enqueue_script('nerubian', get_template_directory_uri() . '/assets/js/dev/nerubian.js', array('jquery'),null, true);

}

/* Load Back-end SCRIPTS============================================================================================= */
function nerubian_js_enqueue()
{
    wp_enqueue_media();
    wp_enqueue_style('thickbox');
    wp_enqueue_script('media-upload');
    wp_enqueue_script('thickbox');
    // moved the js to an external file, you may want to change the path
    wp_enqueue_script('information_js',get_template_directory_uri(). '/assets/js/widget.min.js', 'jquery', '1.0', true);
}
add_action('admin_enqueue_scripts', 'nerubian_js_enqueue');

/* Remove type attribute from script and style tags================================================================== */
add_filter('style_loader_tag', 'myplugin_remove_type_attr', 10, 2);
add_filter('script_loader_tag', 'myplugin_remove_type_attr', 10, 2);

function myplugin_remove_type_attr($tag, $handle) {
    return preg_replace( "/type=['\"]text\/(javascript|css)['\"]/", '', $tag );
}

/* Register the required plugins    ================================================================================= */
add_action( 'tgmpa_register', 'nerubian_register_required_plugins' );
function nerubian_register_required_plugins() {

    $plugins = array(
        // This is an example of how to include a plugin pre-packaged with a theme.
        array(
            'name'      => esc_html__( 'Nano Core Plugin', 'nerubian' ),
            'slug'      => 'theme-core',
            'source'    => get_template_directory() . '/inc/theme-plugins/theme-core.zip',
            'required'  => true,
            'version'   => '1.0.2',
            'force_activation' => false,
            'force_deactivation' => false,
            'image_url' => get_template_directory_uri() . '/inc/backend/assets/images/plugins/nano.jpg',

        ),
        //Contact form 7
        array(
            'name'      => esc_html__('Contact Form 7', 'nerubian' ),
            'slug'      => 'contact-form-7',
            'required'  => false,
            'image_url' => get_template_directory_uri() . '/inc/backend/assets/images/plugins/contact-form7.jpg',
        ),
        //WPBakery Visual Composer
        array(
            'name'      =>  esc_html__('WPBakery Page Builder', 'nerubian' ),
            'slug'      => 'js_composer',
            'source'    => get_template_directory() . '/inc/theme-plugins/js_composer.zip',
            'required'  => true,
            'version'   => '5.6',
            'image_url' => get_template_directory_uri() . '/inc/backend/assets/images/plugins/vc.jpg',
        ),
        //MailChimp for WordPress
        array(
            'name'      =>  esc_html__('MailChimp for WordPress ', 'nerubian' ),
            'slug'      => 'mailchimp-for-wp',
            'required'  => false,
            'image_url' => get_template_directory_uri() . '/inc/backend/assets/images/plugins/mailchimp.jpg',
        ),
        //Instagram
        array(
            'name'      =>  esc_html__('Instagram Feed', 'nerubian' ),
            'slug'      => 'instagram-feed',
            'required'  => false,
            'image_url' => get_template_directory_uri() . '/inc/backend/assets/images/plugins/instagram.jpg',
        ),
        //Social Counter
        array(
            'name'      =>  esc_html__('AccessPress Social Counter', 'nerubian' ),
            'slug'      => 'accesspress-social-counter',
            'required'  => false,
            'image_url' => get_template_directory_uri() . '/inc/backend/assets/images/plugins/ap.jpg',
        ),

    );

    $config = array(
        'id'           => 'nerubian',                   // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                       // Default absolute path to pre-packaged plugins.
        'has_notices'  => true,
        'menu'         => 'tgmpa-install-plugins',  // Menu slug.
        'dismiss_msg'  => '',                       // If 'dismissable' is false, this message will be output at top of nag.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'is_automatic' => true,                     // Automatically activate plugins after installation or not.
        'message'      => '',                       // Message to output right before the plugins table.

    );

    tgmpa( $plugins, $config );

}

/* Register Navigation ============================================================================================== */
register_nav_menus( array(
    'primary_navigation'    => esc_html__( 'Primary Navigation', 'nerubian' ),
    'top_navigation'        => esc_html__( 'Topbar Navigation', 'nerubian' ),
) );

/* Register Sidebar ================================================================================================= */
if ( function_exists('register_sidebar') ) {
    register_sidebar( array(
        'name'          => esc_html__( 'Archive', 'nerubian' ),
        'id'            => 'archive',
        'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'nerubian' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widgettitle">',
        'after_title'   => '</h2>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Blogs', 'nerubian' ),
        'id'            => 'blogs',
        'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'nerubian' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widgettitle">',
        'after_title'   => '</h2>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Single', 'nerubian' ),
        'id'            => 'single',
        'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'nerubian' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widgettitle">',
        'after_title'   => '</h2>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Shop', 'nerubian' ),
        'id'            => 'shop',
        'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'nerubian' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widgettitle">',
        'after_title'   => '</h2>',
    ) );
    register_sidebar(array(
        'name' => esc_html__('Footer 1','nerubian'),
        'id'   => 'footer-1',
        'before_widget' => '<div id="%1$s" class="widget first %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widgettitle">',
        'after_title' => '</h2>',
    ));
    register_sidebar(array(
        'name' => esc_html__('Footer 2','nerubian'),
        'id'   => 'footer-2',
        'before_widget' => '<div id="%1$s" class="widget first %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widgettitle">',
        'after_title' => '</h2>',
    ));
    register_sidebar(array(
        'name' => esc_html__('Footer 3','nerubian'),
        'id'   => 'footer-3',
        'before_widget' => '<div id="%1$s" class="widget first %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widgettitle">',
        'after_title' => '</h2>',
    ));
    register_sidebar(array(
        'name' => esc_html__('Topbar Left','nerubian'),
        'id'   => 'topbar-left',
        'before_widget' => '<div id="%1$s" class="widget first %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widgettitle">',
        'after_title' => '</h2>',
    ));
    register_sidebar(array(
        'name' => esc_html__('Topbar Right','nerubian'),
        'id'   => 'topbar-right',
        'before_widget' => '<div id="%1$s" class="widget first %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widgettitle">',
        'after_title' => '</h2>',
    ));
    register_sidebar(array(
        'name' => esc_html__('Custom Header Left','nerubian'),
        'id'   => 'custom-header-middle',
        'before_widget' => '<div id="%1$s" class="widget first %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widgettitle">',
        'after_title' => '</h2>',
    ));
    register_sidebar(array(
        'name' => esc_html__('Custom Copy Right','nerubian'),
        'id'   => 'copy-right',
        'before_widget' => '<div id="%1$s" class="widget first %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widgettitle">',
        'after_title' => '</h2>',
    ));
}